unit mHanoi;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, Buttons;

type
  TPosition = (links, mitte, rechts);

  TfrmMain = class(TForm)
    memHanoi: TMemo;
    Label1: TLabel;
    SpE_Anzahl: TSpinEdit;
    btUmlegen: TButton;
    procedure btUmlegenClick(Sender: TObject);
  private
    procedure Move(anz: integer; von, hilf, nach: TPosition);
  end;

var
  frmMain: TfrmMain;

implementation {$R *.DFM}

procedure TfrmMain.Move(anz: integer; von, hilf, nach: TPosition);
var s: string[50];
const leerstr='                    ';
begin
  if anz>1 then Move(anz-1, von, nach, hilf);
  s:= copy(leerstr,1,(SpE_Anzahl.Value-anz)*2)+'Lege Scheibe '+ inttostr(anz) + ' von ';
  case von of
    links: s:= s+ 'links';
    rechts: s:= s+ 'rechts';
    mitte: s:= s+ 'der Mitte';
  end;
  case nach of
    links: s:= s+ ' nach links';
    rechts: s:= s+ ' nach rechts';
    mitte: s:= s+ ' in die Mitte';
  end;
  memHanoi.Lines.Add(s);
  if anz>1 then Move(anz-1, hilf, von, nach);
end;


procedure TfrmMain.btUmlegenClick(Sender: TObject);
begin
  memHanoi.Lines.Clear;
  Move(SpE_Anzahl.Value, links, mitte, rechts);
end;

end.
